from core.vboxmanager import *
from core.dates import *
import time
import sys
import os


apps = {
	'flash': FLASH,
	'java': JAVA,
	'quicktime': QUICKTIME,
	'opera': OPERA,
	'msie': MSIE,
	'reader': READER,
	'firefox': FIREFOX
}


def get_app_record(app, version):
	for r in app:
		if r['version']==version:
			return r['filename']

def install_app(name, version, sb):

	#if version==None:
	#	logInfo("No %s for this configuration")

	if name == 'flash':
		f = get_app_record(FLASH, version)
		sb.installFlash('files/'+f)
	elif name == 'java':
		f = get_app_record(JAVA, version)
		if version[0]==1:
			sb.installJava('files/'+f, 0)
		else:
			sb.installJava('files/'+f, 1)

	elif name == 'quicktime':
		f = get_app_record(QUICKTIME, version)
		if (version[1]<=1 and version[2]<3) or version[1]==0:
			sb.installQuickTime('files/'+f, 0)
		else:
			sb.installQuickTime('files/'+f, 1)

	elif name == 'msie':
		f = get_app_record(MSIE, version)
		sb.installIE('files/'+f)
	elif name == 'opera':
		f = get_app_record(OPERA, version)
		if version[0]<11:
			sb.installOpera('files/'+f, 0)
		else:
			sb.installOpera('files/'+f, 1)

	elif name == 'reader':
		f = get_app_record(READER, version)
		if version[0]<8:	
			sb.installReader('files/'+f, 0)
		else:
			sb.installReader('files/'+f, 1)			

	elif name == 'firefox':
		f = get_app_record(FIREFOX, version)
		sb.installFirefox('files/'+f)


def configvm(conf, sb):
	for c in conf:
		install_app(c['name'], c['version'], sb)

#sb = SandBox(vmname, username, password)
#sb.startVM()
#install_app('flash', (9, 0, 47, 0), sb)
#time.sleep(3)


#sb.copyTo("test.txt", "C:/test.txt")

#sb.installFirefox("vulnsoft/Firefox Setup 3.0.5.exe")
#sb.runFirefox("google.com", 10000)

#sb.installOpera("vulnsoft/Opera_9.52.exe")
#sb.runOpera("google.com", 10000)

#sb.installJava("vulnsoft/j2re-1_4_2_18-windows-i586-p.exe")

#sb.installFlash("vulnsoft/flashplayer9r28_win.exe")

#sb.installReader("vulnsoft/AdbeRdr930_en_US.exe")

#sb.installQuickTime("vulnsoft/quicktime713.exe")

#sb.installIE("vulnsoft/IE7-WindowsXP-x86-enu.exe")
#sb.runIE("http://google.com", 10000)

#sb.stopVM()
