import subprocess
import os
from logging import logError, logInfo
from vboxapi import VirtualBoxManager
import vboxshell
import time

MANAGER = "VBoxManage"

class SandBox:
        
	INSTALL_TIMEOUT = 300000
	GUEST_INSTALLER = "C:/installer.exe"
	GUEST_INSTALLER_RUN = "C:\\installer.exe"
	BAT_NAME = 'install.bat'
	BAT = "C:/%s"%BAT_NAME
	BAT_RUN = "C:\\%s"%BAT_NAME
	SNAPSHOTNAME = 'temp'

	def __init__(self, vm_name, username, password):
		self.vm_name = vm_name
		self.username = username
		self.password = password


	def execute(self, image, args, timeout):
		callargs = [
			MANAGER,
			"guestcontrol",
			self.vm_name, 
			"execute",
			"--image", 
			image,
			"--username",
			self.username,
			"--password",
			self.password, 
			"--timeout", 
			str(timeout),
			"--wait-exit",
			]

		if len(args)!=0:
			callargs.append("--")
			callargs.extend(args)

		#print callargs
		subprocess.call(callargs)


	def startVM(self):
		subprocess.call([MANAGER, "startvm", self.vm_name])

	def stopVM(self):
		subprocess.call([MANAGER, "controlvm", self.vm_name, "poweroff"])

	def pause(self):
		subprocess.call([MANAGER, "controlvm", self.vm_name, "pause"])

	def resume(self):
		subprocess.call([MANAGER, "controlvm", self.vm_name, "resume"])


	def restoreSnapshot(self, snapshot):
		subprocess.call([MANAGER, "snapshot", self.vm_name, "restore", snapshot])

	def deleteSnapshot(self):
		subprocess.call([MANAGER, "snapshot", self.vm_name, "delete", self.SNAPSHOTNAME])

	def takeSnapshot(self):
		subprocess.call([MANAGER, "snapshot", self.vm_name, "take", self.SNAPSHOTNAME])
    
	def restoreCurrentSnapshot(self):
		subprocess.call([MANAGER, "snapshot", self.vm_name, "restorecurrent"])


	def copyTo(self, src_host, dst_guest):
		subprocess.call([
			MANAGER,
			"guestcontrol",
			self.vm_name, 
			"copyto",
			os.path.abspath(src_host),
			dst_guest,
			"--username",
			self.username,
			"--password",
			self.password])

	def copyFrom(self, src_guest, dst_host):
		subprocess.call([
			MANAGER,
			"guestcontrol",
			self.vm_name, 
			"copyfrom",
			src_guest,
			os.path.abspath(dst_host),
			"--username",
			self.username,
			"--password",
			self.password])


	def installFirefox(self, installer):
		logInfo("Installing Firefox: %s"%installer.split("/")[-1])
		self.copyTo(installer, self.GUEST_INSTALLER)
		self.execute(self.GUEST_INSTALLER_RUN, ["-ms"], self.INSTALL_TIMEOUT)
                
		override = "/tmp/override.ini" 
		fd = open(override, "wb")
		fd.write("[XRE]\r\nEnableProfileMigrator=false")
		fd.close()

		self.copyTo(override, "C:/Program Files/Mozilla Firefox/override.ini")
		logInfo("Done")



	def runBrowser(self, browser, url, timeout):
		if browser == 'msie':
			self.runIE(url, timeout)
		elif browser == 'firefox':
			self.runFirefox(url, timeout)
		elif browser == 'opera':
			self.runOpera(url, timeout)

	def runFirefox(self, url, timeout):
		self.execute(
			"C:/Program Files/Mozilla Firefox/firefox.exe", 
			["-setDefaultBrowser", url], 
			timeout)

	def installOpera(self, installer, type_):
		logInfo("Installing Opera: %s"%installer.split("/")[-1])
		self.copyTo(installer, self.GUEST_INSTALLER)
		if type_==0:
			self.execute(self.GUEST_INSTALLER_RUN, ["/S", "/v/qn"], self.INSTALL_TIMEOUT)
		else:
			self.execute(self.GUEST_INSTALLER_RUN, ["/silent",  "/launchopera", "0", "/desktopshortcut", "1", "/quicklaunchshortcut", "0", "/setdefaultbrowser", "1", "/allusers"], self.INSTALL_TIMEOUT)
		logInfo("Done")

	def runOpera(self, url, timeout):
		self.execute("C:/Program Files/Opera/opera.exe", [url], timeout)

	def installIE(self, installer):
		logInfo("Installing Internet Explorer: %s"%installer.split("/")[-1])
		self.copyTo(installer, self.GUEST_INSTALLER)
		self.execute(self.GUEST_INSTALLER_RUN, ["/passive", "/quiet", "/update-no", "/norestart"], self.INSTALL_TIMEOUT)
		logInfo("Done")

	def runIE(self, url, timeout):
		self.execute("C:/Program Files/Internet Explorer/iexplore.exe", [url], timeout)

	def installJava(self, installer, type_):
		logInfo("Installing Java: %s"%installer.split("/")[-1])
		self.copyTo(installer, self.GUEST_INSTALLER)
		if type_==0:
			self.batInstall('%s /v"/qn IEXPLORER=1 MOZILLA=1'%self.GUEST_INSTALLER_RUN)
		else:
			self.execute(self.GUEST_INSTALLER_RUN, ["/s", "WEB_JAVA=1"], self.INSTALL_TIMEOUT)
		logInfo("Done")

	def installFlash(self, installer):
		logInfo("Installing Flash Player: %s"%installer.split("/")[-1])
		self.copyTo(installer, self.GUEST_INSTALLER)
		self.execute(self.GUEST_INSTALLER_RUN, ["/s"], self.INSTALL_TIMEOUT)
		logInfo("Done")

	def batInstall(self, cmd):
		fd = open(self.BAT_NAME, 'wb')
		fd.write(cmd)
		fd.close()
		self.copyTo(self.BAT_NAME, self.BAT)
		self.execute(self.BAT_RUN, [], self.INSTALL_TIMEOUT)


	def installReader(self, installer, type_):
		logInfo("Installing Acrobat Reader: %s"%installer.split("/")[-1])
		self.copyTo(installer, self.GUEST_INSTALLER)

		if type_ == 0:
			self.batInstall('%s /v"/qn EULA_ACCEPT=YES'%self.GUEST_INSTALLER_RUN)
		else:
			self.execute(self.GUEST_INSTALLER_RUN, ["/msi", "EULA_ACCEPT=YES", "/qn"], self.INSTALL_TIMEOUT)

		logInfo("Done")

	def installQuickTime(self, installer, type_):
		logInfo("Installing Quicktime: %s"%installer.split("/")[-1])
		self.copyTo(installer, self.GUEST_INSTALLER)
		if type_ == 0:
			self.execute(self.GUEST_INSTALLER_RUN, ["/S", "/v/qn"], self.INSTALL_TIMEOUT)
			logInfo("Sleeping for 200 seconds")
			time.sleep(200)
			logInfo("Continuing...")
		else:
			self.execute(self.GUEST_INSTALLER, ["/msi", "/quiet", "/passive"], self.INSTALL_TIMEOUT)
		
		logInfo("Done")
