from core.dates import *
from vmconfig import apps

import sys
import random

# Size of sliding window in years
WINDOW = 2

START_YEAR = 2006
END_YEAR = 2013 # This one is not included
CONFIG_NUM = 30
BROWSERS = ['firefox', 'msie', 'opera']
PLUGINS = ['flash', 'reader', 'java', 'quicktime']

def get_random(num, lst):
	res = []
	while len(res)!=num:
		res.append(random.choice(lst))
	return res


def dump(configs):
	print "year,browser,browserversion,flash,reader,quicktime,java"
	for config in configs:
		print config
		sys.exit()

def get_apps_for_years(appname, start_year, end_year):
	files = apps[appname]
	subset = []
	for entry in files:
		y_ = entry['date'].year
		if y_>=start_year and y_<end_year:
			subset.append("%d-%d-%d-%d"%entry['version'])
	return subset

def main():

	# Loop through the years
	# using the sliding window

	id_ = 0
	print "year,browser,browserversion,flash,reader,quicktime,java"
	for year in range(START_YEAR, END_YEAR-WINDOW+1):
		for i in xrange(CONFIG_NUM):
			browser = random.choice(BROWSERS)
			if browser=='msie':
				browserversion = '0'
			else:
				browserversion = random.choice(get_apps_for_years(browser, year, year+1))
			plver={}
			for p in PLUGINS:
				versions = get_apps_for_years(p, year, year+1)
				versions.extend(['None'])
				plver[p] = random.choice(versions)
		
			print "%d,%s,%s,%s,%s,%s,%s,%d"%(year, browser, browserversion,plver['flash'], plver['reader'], plver['quicktime'], plver['java'],id_)
			id_ += 1




if __name__ == "__main__":
	main()
